/*
 * Decompiled with CFR 0.152.
 */
package jade.core.mobility;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentDescriptor;
import jade.core.BaseService;
import jade.core.CaseInsensitiveString;
import jade.core.Command;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.LifeCycle;
import jade.core.Location;
import jade.core.MainContainer;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.ServiceHelper;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.management.AgentManagementService;
import jade.core.management.CodeLocator;
import jade.core.mobility.AgentMobilityHelper;
import jade.core.mobility.AgentMobilitySlice;
import jade.core.mobility.MobileAgentClassLoader;
import jade.core.mobility.Movable;
import jade.lang.acl.ACLMessage;
import jade.security.Credentials;
import jade.security.CredentialsHelper;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AgentMobilityService
extends BaseService {
    public static final String NAME = "jade.core.mobility.AgentMobility";
    public static final int AP_TRANSIT = 7;
    public static final int AP_COPY = 8;
    public static final int AP_GONE = 9;
    private static final String[] OWNED_COMMANDS = new String[]{"Request-Move", "Request-Clone", "Inform-Moved", "Inform-Cloned"};
    static final boolean MIGRATION = false;
    static final boolean CLONING = true;
    static final boolean CREATE_AND_START = true;
    static final boolean CREATE_ONLY = false;
    static final boolean TRANSFER_ABORT = false;
    static final boolean TRANSFER_COMMIT = true;
    private final Map loaders = new HashMap();
    private final Map sites = new HashMap();
    private AgentContainer myContainer;
    private final ServiceComponent localSlice = new ServiceComponent();
    private final CommandSourceSink senderSink = new CommandSourceSink();
    private final CommandTargetSink receiverSink = new CommandTargetSink();
    static /* synthetic */ Class class$jade$core$mobility$AgentMobilitySlice;

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
    }

    public String getName() {
        return NAME;
    }

    public Class getHorizontalInterface() {
        return class$jade$core$mobility$AgentMobilitySlice == null ? (class$jade$core$mobility$AgentMobilitySlice = AgentMobilityService.class$("jade.core.mobility.AgentMobilitySlice")) : class$jade$core$mobility$AgentMobilitySlice;
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public ServiceHelper getHelper(Agent a) {
        return new AgentMobilityHelperImpl();
    }

    public Filter getCommandFilter(boolean direction) {
        return null;
    }

    public Sink getCommandSink(boolean side) {
        if (!side) {
            return this.senderSink;
        }
        return this.receiverSink;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public String getClassSite(Agent a) {
        return (String)this.sites.get(a);
    }

    protected Service.Slice getFreshSlice(String name) throws ServiceException {
        return super.getFreshSlice(name);
    }

    private void initCredentials(Command cmd, AID id) {
        Agent agent = this.myContainer.acquireLocalAgent(id);
        if (agent != null) {
            try {
                CredentialsHelper ch = (CredentialsHelper)((Object)agent.getHelper("jade.core.security.Security"));
                cmd.setPrincipal(ch.getPrincipal());
                cmd.setCredentials(ch.getCredentials());
            }
            catch (ServiceException se) {
                // empty catch block
            }
        }
        this.myContainer.releaseLocalAgent(id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CopyLifeCycle
    extends LifeCycle {
        private Location myDestination;
        private String myNewName;
        private Movable myMovable;
        private transient AgentMobilityService myService;
        private Logger myLogger;
        private boolean firstTime = true;
        private boolean messageAware = false;

        private CopyLifeCycle(Location l, String newName, Movable m, AgentMobilityService s) {
            super(8);
            this.myDestination = l;
            this.myNewName = newName;
            this.myMovable = m;
            this.myService = s;
            this.myLogger = Logger.getMyLogger(this.myService.getName());
        }

        public void init() {
            this.myAgent.restoreBufferedState();
            if (this.myMovable != null) {
                this.myMovable.afterClone();
            }
        }

        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            try {
                if (this.firstTime) {
                    this.firstTime = false;
                    if (this.myMovable != null) {
                        this.messageAware = true;
                        this.myMovable.beforeClone();
                        this.messageAware = false;
                    }
                    this.informCloned(this.myAgent.getAID(), this.myDestination, this.myNewName);
                }
            }
            catch (Exception e) {
                if (this.myAgent.getState() == this.myState) {
                    this.myDestination = null;
                    this.myNewName = null;
                    this.myAgent.restoreBufferedState();
                    if (e instanceof JADESecurityException) {
                        throw (JADESecurityException)e;
                    }
                    e.printStackTrace();
                    return;
                }
                throw new Agent.Interrupted();
            }
            this.myAgent.restoreBufferedState();
        }

        public boolean transitionTo(LifeCycle newLF) {
            int s = newLF.getState();
            return s == 2 || s == 6;
        }

        public boolean isMessageAware() {
            return this.messageAware;
        }

        public void end() {
            if (this.myLogger.isLoggable(Logger.SEVERE)) {
                this.myLogger.log(Logger.SEVERE, "***  Agent " + this.myAgent.getName() + " cloned in a forbidden situation ***");
            }
            this.myAgent.clean(true);
        }

        public void informCloned(AID agentID, Location where, String newName) throws ServiceException, JADESecurityException, IMTPException, NotFoundException, NameClashException {
            GenericCommand cmd = new GenericCommand("Inform-Cloned", AgentMobilityService.NAME, null);
            cmd.addParam(agentID);
            cmd.addParam(where);
            cmd.addParam(newName);
            this.myService.initCredentials(cmd, agentID);
            Object lastException = this.myService.submit(cmd);
            if (lastException != null) {
                if (lastException instanceof JADESecurityException) {
                    throw (JADESecurityException)lastException;
                }
                if (lastException instanceof NotFoundException) {
                    throw (NotFoundException)lastException;
                }
                if (lastException instanceof IMTPException) {
                    throw (IMTPException)lastException;
                }
                if (lastException instanceof NameClashException) {
                    throw (NameClashException)lastException;
                }
            }
        }
    }

    private static class TransitLifeCycle
    extends LifeCycle {
        private Location myDestination;
        private Movable myMovable;
        private transient AgentMobilityService myService;
        private Logger myLogger;
        private boolean firstTime = true;
        private boolean messageAware = false;

        private TransitLifeCycle(Location l, Movable m, AgentMobilityService s) {
            super(7);
            this.myDestination = l;
            this.myMovable = m;
            this.myService = s;
            this.myLogger = Logger.getMyLogger(this.myService.getName());
        }

        public void init() {
            this.myAgent.restoreBufferedState();
            if (this.myMovable != null) {
                this.myMovable.afterMove();
            }
        }

        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            try {
                if (this.firstTime) {
                    this.firstTime = false;
                    if (this.myMovable != null) {
                        this.messageAware = true;
                        this.myMovable.beforeMove();
                        this.messageAware = false;
                    }
                    this.informMoved(this.myAgent.getAID(), this.myDestination);
                }
            }
            catch (Exception e) {
                if (this.myAgent.getState() == this.myState) {
                    this.myAgent.restoreBufferedState();
                    this.myDestination = null;
                    if (e instanceof JADESecurityException) {
                        throw (JADESecurityException)e;
                    }
                    e.printStackTrace();
                }
                throw new Agent.Interrupted();
            }
        }

        public void end() {
            if (this.myLogger.isLoggable(Logger.SEVERE)) {
                this.myLogger.log(Logger.SEVERE, "***  Agent " + this.myAgent.getName() + " moved in a forbidden situation ***");
            }
            this.myAgent.clean(true);
        }

        public boolean transitionTo(LifeCycle newLF) {
            int s = newLF.getState();
            return s == 9 || s == 2 || s == 6;
        }

        public boolean isMessageAware() {
            return this.messageAware;
        }

        public void informMoved(AID agentID, Location where) throws ServiceException, JADESecurityException, NotFoundException, IMTPException {
            GenericCommand cmd = new GenericCommand("Inform-Moved", AgentMobilityService.NAME, null);
            cmd.addParam(agentID);
            cmd.addParam(where);
            this.myService.initCredentials(cmd, agentID);
            Object lastException = this.myService.submit(cmd);
            if (lastException != null) {
                if (lastException instanceof JADESecurityException) {
                    throw (JADESecurityException)lastException;
                }
                if (lastException instanceof NotFoundException) {
                    throw (NotFoundException)lastException;
                }
                if (lastException instanceof IMTPException) {
                    throw (IMTPException)lastException;
                }
            }
        }
    }

    private class AgentMobilityHelperImpl
    implements AgentMobilityHelper {
        private Agent myAgent;
        private Movable myMovable;

        private AgentMobilityHelperImpl() {
        }

        public void init(Agent a) {
            this.myAgent = a;
        }

        public void registerMovable(Movable m) {
            this.myMovable = m;
        }

        public void move(Location destination) {
            this.myAgent.changeStateTo(new TransitLifeCycle(destination, this.myMovable, AgentMobilityService.this));
        }

        public void clone(Location destination, String newName) {
            this.myAgent.changeStateTo(new CopyLifeCycle(destination, newName, this.myMovable, AgentMobilityService.this));
        }
    }

    private class Deserializer
    extends ObjectInputStream {
        private String agentName;
        private String classSiteName;
        private ServiceFinder finder;

        public Deserializer(InputStream inner, String an, String sliceName, ServiceFinder sf) throws IOException {
            super(inner);
            this.agentName = an;
            this.classSiteName = sliceName;
            this.finder = sf;
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            MobileAgentClassLoader cl = (MobileAgentClassLoader)AgentMobilityService.this.loaders.get(this.classSiteName);
            if (cl == null) {
                cl = new MobileAgentClassLoader(this.agentName, this.classSiteName, this.finder);
                AgentMobilityService.this.loaders.put(this.classSiteName, cl);
            }
            Class<?> c = cl.loadClass(v.getName());
            return c;
        }
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return AgentMobilityService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return AgentMobilityService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            Command result;
            block17: {
                result = null;
                try {
                    String cmdName = cmd.getName();
                    Object[] params = cmd.getParams();
                    if (cmdName.equals("1")) {
                        AID agentID = (AID)params[0];
                        byte[] serializedInstance = (byte[])params[1];
                        String classSiteName = (String)params[2];
                        boolean isCloned = (Boolean)params[3];
                        boolean startIt = (Boolean)params[4];
                        this.createAgent(agentID, serializedInstance, classSiteName, isCloned, startIt);
                    } else if (cmdName.equals("2")) {
                        String className = (String)params[0];
                        String agentName = (String)params[1];
                        cmd.setReturnValue(this.fetchClassFile(className, agentName));
                    } else if (cmdName.equals("3")) {
                        GenericCommand gCmd = new GenericCommand("Request-Move", AgentMobilityService.NAME, null);
                        AID agentID = (AID)params[0];
                        Location where = (Location)params[1];
                        gCmd.addParam(agentID);
                        gCmd.addParam(where);
                        result = gCmd;
                    } else if (cmdName.equals("4")) {
                        GenericCommand gCmd = new GenericCommand("Request-Clone", AgentMobilityService.NAME, null);
                        AID agentID = (AID)params[0];
                        Location where = (Location)params[1];
                        String newName = (String)params[2];
                        gCmd.addParam(agentID);
                        gCmd.addParam(where);
                        gCmd.addParam(newName);
                        result = gCmd;
                    } else if (cmdName.equals("5")) {
                        cmd.setReturnValue(new Boolean(this.prepare()));
                    } else if (cmdName.equals("6")) {
                        AID agentID = (AID)params[0];
                        Location src = (Location)params[1];
                        Location dest = (Location)params[2];
                        cmd.setReturnValue(new Boolean(this.transferIdentity(agentID, src, dest)));
                    } else if (cmdName.equals("7")) {
                        AID agentID = (AID)params[0];
                        boolean transferResult = (Boolean)params[1];
                        List messages = (List)params[2];
                        this.handleTransferResult(agentID, transferResult, messages);
                    } else if (cmdName.equals("8")) {
                        GenericCommand gCmd = new GenericCommand("Inform-Cloned", AgentMobilityService.NAME, null);
                        AID agentID = (AID)params[0];
                        ContainerID cid = (ContainerID)params[1];
                        Credentials creds = (Credentials)params[2];
                        gCmd.addParam(agentID);
                        gCmd.addParam(cid);
                        gCmd.addParam(creds);
                        result = gCmd;
                    }
                }
                catch (Throwable t) {
                    cmd.setReturnValue(t);
                    if (result == null) break block17;
                    result.setReturnValue(t);
                }
            }
            return result;
        }

        private void createAgent(AID agentID, byte[] serializedInstance, String classSiteName, boolean isCloned, boolean startIt) throws IMTPException, ServiceException, NotFoundException, NameClashException, JADESecurityException {
            try {
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.CONFIG)) {
                    AgentMobilityService.this.myLogger.log(Logger.CONFIG, "Incoming agent " + agentID.getName());
                }
                Deserializer in = new Deserializer(new ByteArrayInputStream(serializedInstance), agentID.getName(), classSiteName, AgentMobilityService.this.myContainer.getServiceFinder());
                Agent instance = (Agent)in.readObject();
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID + " reconstructed");
                }
                Credentials agentCerts = null;
                if (isCloned) {
                    AgentMobilitySlice mainSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice("$$$Main-Slice$$$");
                    try {
                        mainSlice.clonedAgent(agentID, AgentMobilityService.this.myContainer.getID(), agentCerts);
                    }
                    catch (IMTPException imtpe) {
                        mainSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice("$$$Main-Slice$$$");
                        mainSlice.clonedAgent(agentID, AgentMobilityService.this.myContainer.getID(), agentCerts);
                    }
                }
                AgentMobilityService.this.sites.put(instance, classSiteName);
                Agent old = AgentMobilityService.this.myContainer.addLocalAgent(agentID, instance);
                if (startIt) {
                    AgentMobilityService.this.myContainer.powerUpLocalAgent(agentID);
                }
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID.getName() + " inserted into LADT");
                }
            }
            catch (IOException ioe) {
                throw new IMTPException("An I/O error occurred during de-serialization", ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IMTPException("A class was not found during de-serialization", cnfe);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IMTPException("Unexpected error.", t);
            }
        }

        private byte[] fetchClassFile(String className, String agentName) throws IMTPException, ClassNotFoundException {
            if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                AgentMobilityService.this.myLogger.log(Logger.FINE, "Fetching class " + className);
            }
            String fileName = className.replace('.', '/') + ".class";
            int length = -1;
            InputStream classStream = ClassLoader.getSystemResourceAsStream(fileName);
            if (classStream == null) {
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINER, "Class not found as a system resource. Try manually");
                }
                String currentCp = System.getProperty("java.class.path");
                StringTokenizer st = new StringTokenizer(currentCp, ";");
                while (st.hasMoreTokens()) {
                    try {
                        File f;
                        String path = st.nextToken();
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINER, "Searching in path " + path);
                        }
                        if (path.endsWith(".jar")) {
                            ClassInfo info;
                            if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                                AgentMobilityService.this.myLogger.log(Logger.FINER, "It's a jar file");
                            }
                            if ((info = this.getClassStreamFromJar(fileName, path)) == null) continue;
                            classStream = info.getClassStream();
                            length = info.getLength();
                            break;
                        }
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINER, "Trying file " + path + "/" + fileName);
                        }
                        if (!(f = new File(path + "/" + fileName)).exists()) continue;
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINER, "File exists");
                        }
                        classStream = new FileInputStream(f);
                        break;
                    }
                    catch (Exception e) {
                        if (!AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) continue;
                        AgentMobilityService.this.myLogger.log(Logger.WARNING, e.toString());
                    }
                }
            }
            if (classStream == null) {
                try {
                    AgentManagementService amSrv = (AgentManagementService)AgentMobilityService.this.myFinder.findService("jade.core.management.AgentManagement");
                    String jarName = amSrv.getCodeLocator().getAgentCodeLocation(new AID(agentName, true));
                    ClassInfo info = this.getClassStreamFromJar(fileName, jarName);
                    classStream = info.getClassStream();
                    length = info.getLength();
                }
                catch (NullPointerException npe) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (classStream == null) {
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) {
                    AgentMobilityService.this.myLogger.log(Logger.WARNING, "Class " + className + " not found");
                }
                throw new ClassNotFoundException(className);
            }
            try {
                if (length == -1) {
                    length = classStream.available();
                }
                byte[] bytes = new byte[length];
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINER, "Class " + className + " fetched. Length is " + length);
                }
                DataInputStream dis = new DataInputStream(classStream);
                dis.readFully(bytes);
                return bytes;
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException("IOException reading class bytes. " + ioe.getMessage());
            }
        }

        private ClassInfo getClassStreamFromJar(String classFileName, String jarName) throws IOException {
            ZipFile zf;
            ZipEntry e;
            File f = new File(jarName);
            if (f.exists() && AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                AgentMobilityService.this.myLogger.log(Logger.FINER, "Jar file exists");
            }
            if ((e = (zf = new ZipFile(f)).getEntry(classFileName)) != null) {
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                    AgentMobilityService.this.myLogger.log(Logger.FINER, "Entry " + classFileName + " found");
                }
                return new ClassInfo(zf.getInputStream(e), (int)e.getSize());
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleTransferResult(AID agentID, boolean result, List messages) throws IMTPException, NotFoundException {
            if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINER)) {
                AgentMobilityService.this.myLogger.log(Logger.FINER, "Activating incoming agent " + agentID);
            }
            try {
                Agent agent = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID);
                if (agent == null || agent.getState() != 7) {
                    throw new NotFoundException("handleTransferResult() unable to find a suitable agent.");
                }
                if (!result) {
                    AgentMobilityService.this.myContainer.removeLocalAgent(agentID);
                } else {
                    int i = messages.size();
                    while (i > 0) {
                        agent.putBack((ACLMessage)messages.get(i - 1));
                        --i;
                    }
                    AgentMobilityService.this.myContainer.powerUpLocalAgent(agentID);
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.CONFIG)) {
                        AgentMobilityService.this.myLogger.log(Logger.CONFIG, "Incoming agent " + agentID.getName() + " activated");
                    }
                }
                Object var7_6 = null;
                AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
                throw throwable;
            }
        }

        private boolean prepare() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean transferIdentity(AID agentID, Location src, Location dest) throws IMTPException, NotFoundException {
            MainContainer impl;
            if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                AgentMobilityService.this.myLogger.log(Logger.FINE, "Transferring identity of agent " + agentID + " from " + src.getName() + " to " + dest.getName());
            }
            if ((impl = AgentMobilityService.this.myContainer.getMain()) != null) {
                AgentDescriptor ad = impl.acquireAgentDescriptor(agentID);
                if (ad != null) {
                    block16: {
                        AgentMobilitySlice srcSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(src.getName());
                        AgentMobilitySlice destSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(dest.getName());
                        boolean srcReady = false;
                        boolean destReady = false;
                        try {
                            srcReady = srcSlice.prepare();
                        }
                        catch (IMTPException imtpe) {
                            srcSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(src.getName());
                            srcReady = srcSlice.prepare();
                        }
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINE, "Source " + src.getName() + " " + srcReady);
                        }
                        try {
                            destReady = destSlice.prepare();
                        }
                        catch (IMTPException imtpe) {
                            destSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(dest.getName());
                            destReady = destSlice.prepare();
                        }
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINE, "Destination " + dest.getName() + " " + destReady);
                        }
                        if (!srcReady || !destReady) break block16;
                        impl.movedAgent(agentID, (ContainerID)src, (ContainerID)dest);
                        boolean bl = true;
                        Object var12_17 = null;
                        impl.releaseAgentDescriptor(agentID);
                        return bl;
                    }
                    try {
                        boolean bl = false;
                        Object var12_18 = null;
                        impl.releaseAgentDescriptor(agentID);
                        return bl;
                    }
                    catch (Exception e) {
                        try {
                            if (AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) {
                                AgentMobilityService.this.myLogger.log(Logger.WARNING, "Link failure!");
                            }
                            boolean bl = false;
                            Object var12_19 = null;
                            impl.releaseAgentDescriptor(agentID);
                            return bl;
                        }
                        catch (Throwable throwable) {
                            Object var12_20 = null;
                            impl.releaseAgentDescriptor(agentID);
                            throw throwable;
                        }
                    }
                }
                throw new NotFoundException("Agent agentID not found");
            }
            if (AgentMobilityService.this.myLogger.isLoggable(Logger.WARNING)) {
                AgentMobilityService.this.myLogger.log(Logger.WARNING, "Not a main!");
            }
            return false;
        }

        private class ClassInfo {
            private InputStream classStream;
            private int length = -1;

            public ClassInfo(InputStream is, int l) {
                this.classStream = is;
                this.length = l;
            }

            public InputStream getClassStream() {
                return this.classStream;
            }

            public int getLength() {
                return this.length;
            }
        }
    }

    private class CommandTargetSink
    implements Sink {
        private CommandTargetSink() {
        }

        public void consume(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Request-Move")) {
                    this.handleRequestMove(cmd);
                } else if (name.equals("Request-Clone")) {
                    this.handleRequestClone(cmd);
                } else if (name.equals("Inform-Moved")) {
                    this.handleInformMoved(cmd);
                } else if (name.equals("Inform-Cloned")) {
                    this.handleInformCloned(cmd);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
        }

        private void handleRequestMove(VerticalCommand cmd) throws IMTPException, NotFoundException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            Location where = (Location)params[1];
            this.moveAgent(agentID, where);
        }

        private void handleRequestClone(VerticalCommand cmd) throws IMTPException, NotFoundException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            Location where = (Location)params[1];
            String newName = (String)params[2];
            this.copyAgent(agentID, where, newName);
        }

        private void handleInformMoved(VerticalCommand cmd) {
        }

        private void handleInformCloned(VerticalCommand cmd) throws JADESecurityException, NotFoundException, NameClashException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            ContainerID cid = (ContainerID)params[1];
            Credentials creds = (Credentials)params[2];
            this.clonedAgent(agentID, cid, creds);
        }

        private void moveAgent(AID agentID, Location where) throws IMTPException, NotFoundException {
            Agent a = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID);
            if (a == null) {
                throw new NotFoundException("Move-Agent failed to find " + agentID);
            }
            a.doMove(where);
            AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
        }

        private void copyAgent(AID agentID, Location where, String newName) throws IMTPException, NotFoundException {
            Agent a = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID);
            if (a == null) {
                throw new NotFoundException("Clone-Agent failed to find " + agentID);
            }
            a.doClone(where, newName);
            AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
        }

        private void clonedAgent(AID agentID, ContainerID cid, Credentials credentials) throws JADESecurityException, NotFoundException, NameClashException {
            block6: {
                JADEPrincipal ownerPr;
                MainContainer impl = AgentMobilityService.this.myContainer.getMain();
                if (impl == null) break block6;
                String ownership = "NONE";
                if (credentials != null && (ownerPr = credentials.getOwner()) != null) {
                    ownership = ownerPr.getName();
                }
                try {
                    impl.bornAgent(agentID, cid, null, ownership, false);
                }
                catch (NameClashException nce) {
                    try {
                        ContainerID oldCid = impl.getContainerID(agentID);
                        Node n = impl.getContainerNode(oldCid).getNode();
                        n.ping(false);
                        throw nce;
                    }
                    catch (NameClashException nce2) {
                        throw nce2;
                    }
                    catch (Exception e) {
                        impl.bornAgent(agentID, cid, null, ownership, true);
                    }
                }
            }
        }
    }

    private class CommandSourceSink
    implements Sink {
        private CommandSourceSink() {
        }

        public void consume(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Request-Move")) {
                    this.handleRequestMove(cmd);
                } else if (name.equals("Request-Clone")) {
                    this.handleRequestClone(cmd);
                } else if (name.equals("Inform-Moved")) {
                    this.handleInformMoved(cmd);
                } else if (name.equals("Inform-Cloned")) {
                    this.handleInformCloned(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(imtpe);
            }
            catch (NotFoundException nfe) {
                cmd.setReturnValue(nfe);
            }
            catch (NameClashException nce) {
                cmd.setReturnValue(nce);
            }
            catch (JADESecurityException ae) {
                cmd.setReturnValue(ae);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(new IMTPException("Service error", se));
            }
        }

        private void handleRequestMove(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException {
            block2: {
                Object[] params = cmd.getParams();
                AID agentID = (AID)params[0];
                Location where = (Location)params[1];
                MainContainer impl = AgentMobilityService.this.myContainer.getMain();
                if (impl == null) break block2;
                ContainerID cid = impl.getContainerID(agentID);
                AgentMobilitySlice targetSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(cid.getName());
                try {
                    targetSlice.moveAgent(agentID, where);
                }
                catch (IMTPException imtpe) {
                    targetSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(cid.getName());
                    targetSlice.moveAgent(agentID, where);
                }
            }
        }

        private void handleRequestClone(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException {
            block2: {
                Object[] params = cmd.getParams();
                AID agentID = (AID)params[0];
                Location where = (Location)params[1];
                String newName = (String)params[2];
                MainContainer impl = AgentMobilityService.this.myContainer.getMain();
                if (impl == null) break block2;
                ContainerID cid = impl.getContainerID(agentID);
                AgentMobilitySlice targetSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice(cid.getName());
                try {
                    targetSlice.copyAgent(agentID, where, newName);
                }
                catch (IMTPException imtpe) {
                    targetSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(cid.getName());
                    targetSlice.copyAgent(agentID, where, newName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInformMoved(VerticalCommand cmd) throws IMTPException, ServiceException, JADESecurityException, NotFoundException {
            block48: {
                Agent a;
                Object[] params = cmd.getParams();
                AID agentID = (AID)params[0];
                Location where = (Location)params[1];
                if (AgentMobilityService.this.myLogger.isLoggable(Logger.CONFIG)) {
                    AgentMobilityService.this.myLogger.log(Logger.CONFIG, "Moving agent " + agentID.getName() + " on container " + where.getName());
                }
                if ((a = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID)) == null) {
                    AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Internal error: handleMove() called with a wrong name (" + agentID.getName() + ") !!!");
                    return;
                }
                String proto = where.getProtocol();
                if (!CaseInsensitiveString.equalsIgnoreCase(proto, "JADE-IMTP")) {
                    AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Mobility protocol not supported. Aborting transfer");
                    a.restoreBufferedState();
                    return;
                }
                int transferState = 0;
                ArrayList messages = new ArrayList();
                AgentMobilitySlice dest = null;
                try {
                    String classSiteName;
                    if (CaseInsensitiveString.equalsIgnoreCase(where.getName(), AgentMobilityService.this.myContainer.here().getName())) {
                        return;
                    }
                    dest = (AgentMobilitySlice)AgentMobilityService.this.getSlice(where.getName());
                    if (dest == null) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Destination " + where.getName() + " does not exist or does not support mobility");
                        return;
                    }
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                        AgentMobilityService.this.myLogger.log(Logger.FINE, "Destination container for agent " + agentID + " found");
                    }
                    transferState = 1;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ObjectOutputStream encoder = new ObjectOutputStream(out);
                    encoder.writeObject(a);
                    byte[] bytes = out.toByteArray();
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                        AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID.getName() + " correctly serialized");
                    }
                    if ((classSiteName = (String)AgentMobilityService.this.sites.get(a)) == null) {
                        classSiteName = AgentMobilityService.this.getLocalNode().getName();
                    }
                    try {
                        dest.createAgent(agentID, bytes, classSiteName, false, false);
                    }
                    catch (IMTPException imtpe) {
                        dest = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(where.getName());
                        dest.createAgent(agentID, bytes, classSiteName, false, false);
                    }
                    transferState = 2;
                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                        AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID.getName() + " correctly created on destination container");
                    }
                    AgentMobilitySlice mainSlice = (AgentMobilitySlice)AgentMobilityService.this.getSlice("$$$Main-Slice$$$");
                    boolean transferResult = false;
                    try {
                        transferResult = mainSlice.transferIdentity(agentID, (ContainerID)AgentMobilityService.this.myContainer.here(), (ContainerID)where);
                    }
                    catch (IMTPException imtpe) {
                        mainSlice = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice("$$$Main-Slice$$$");
                        transferResult = mainSlice.transferIdentity(agentID, (ContainerID)AgentMobilityService.this.myContainer.here(), (ContainerID)where);
                    }
                    transferState = 3;
                    if (transferResult) {
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINE, "Identity of agent " + agentID.getName() + " correctly transferred");
                        }
                        AgentMobilityService.this.myContainer.fillListFromMessageQueue(messages, a);
                        dest.handleTransferResult(agentID, transferResult, messages);
                        try {
                            a.changeStateTo(new LifeCycle(9){

                                public boolean alive() {
                                    return false;
                                }
                            });
                            AgentMobilityService.this.myContainer.removeLocalAgent(a.getAID());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        AgentMobilityService.this.sites.remove(a);
                        if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                            AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID.getName() + " correctly gone");
                        }
                        break block48;
                    }
                    AgentMobilityService.this.myLogger.log(Logger.WARNING, "Error transferring identity of agent " + agentID.getName());
                    a.restoreBufferedState();
                    dest.handleTransferResult(agentID, transferResult, messages);
                    AgentMobilityService.this.myLogger.log(Logger.WARNING, "Migration of agent " + agentID.getName() + "aborted");
                }
                catch (IOException ioe) {
                    AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Error in agent serialization. Abort transfer. " + ioe);
                }
                catch (JADESecurityException ae) {
                    AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Permission to move not owned. Abort transfer. " + ae.getMessage());
                }
                catch (NotFoundException nfe) {
                    if (transferState == 0) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Destination container does not exist. Abort transfer. " + nfe.getMessage());
                    } else if (transferState == 2) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Transferring agent does not seem to be part of the platform. Abort transfer. " + nfe.getMessage());
                    } else if (transferState == 3) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Transferred agent not found on destination container. Can't roll back. " + nfe.getMessage());
                    }
                }
                catch (NameClashException nce) {
                    nce.printStackTrace();
                }
                catch (IMTPException imtpe) {
                    if (transferState == 0) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Can't retrieve destination container. Abort transfer. " + imtpe.getMessage());
                    } else if (transferState == 1) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Error creating agent on destination container. Abort transfer. " + imtpe.getMessage());
                    } else if (transferState == 2) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Error transferring agent identity. Abort transfer. " + imtpe.getMessage());
                        try {
                            dest.handleTransferResult(agentID, false, messages);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (transferState == 3) {
                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Error activating transferred agent. Can't roll back!!!. " + imtpe.getMessage());
                    }
                }
                finally {
                    if (transferState <= 2) {
                        a.restoreBufferedState();
                    }
                    AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleInformCloned(VerticalCommand cmd) throws IMTPException, NotFoundException, NameClashException, JADESecurityException {
            AID agentID;
            block23: {
                block22: {
                    block21: {
                        Object[] params = cmd.getParams();
                        agentID = (AID)params[0];
                        Location where = (Location)params[1];
                        String newName = (String)params[2];
                        try {
                            try {
                                String classSiteName;
                                Agent a;
                                AgentManagementService amSrv = (AgentManagementService)AgentMobilityService.this.myFinder.findService("jade.core.management.AgentManagement");
                                CodeLocator cl = amSrv.getCodeLocator();
                                String jarName = cl.getAgentCodeLocation(agentID);
                                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                                    AgentMobilityService.this.myLogger.log(Logger.FINE, " adding clone " + newName + " to code locator. Binding to jar: " + jarName);
                                }
                                if (jarName != null) {
                                    cl.registerAgent(new AID(newName, false), new File(jarName), false);
                                }
                                if (AgentMobilityService.this.myLogger.isLoggable(Logger.CONFIG)) {
                                    AgentMobilityService.this.myLogger.log(Logger.CONFIG, "Cloning agent " + agentID + " on container " + where.getName());
                                }
                                if ((a = AgentMobilityService.this.myContainer.acquireLocalAgent(agentID)) == null) {
                                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.SEVERE)) {
                                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Internal error: handleClone() called with a wrong name (" + agentID + ") !!!");
                                    }
                                    Object var19_13 = null;
                                    AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
                                    return;
                                }
                                String proto = where.getProtocol();
                                if (!CaseInsensitiveString.equalsIgnoreCase(proto, "JADE-IMTP")) {
                                    if (AgentMobilityService.this.myLogger.isLoggable(Logger.SEVERE)) {
                                        AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Mobility protocol not supported. Abort cloning");
                                    }
                                    break block21;
                                }
                                AgentMobilitySlice dest = (AgentMobilitySlice)AgentMobilityService.this.getSlice(where.getName());
                                if (dest == null) {
                                    AgentMobilityService.this.myLogger.log(Logger.SEVERE, "Destination " + where.getName() + " does not exist or does not support mobility");
                                    break block22;
                                }
                                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                                    AgentMobilityService.this.myLogger.log(Logger.FINE, "Destination container for agent " + agentID + " found");
                                }
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                ObjectOutputStream encoder = new ObjectOutputStream(out);
                                encoder.writeObject(a);
                                byte[] bytes = out.toByteArray();
                                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                                    AgentMobilityService.this.myLogger.log(Logger.FINE, "Agent " + agentID + " correctly serialized");
                                }
                                if ((classSiteName = (String)AgentMobilityService.this.sites.get(a)) == null) {
                                    classSiteName = AgentMobilityService.this.getLocalNode().getName();
                                }
                                AID newID = new AID(newName, false);
                                try {
                                    dest.createAgent(newID, bytes, classSiteName, true, true);
                                }
                                catch (IMTPException imtpe) {
                                    dest = (AgentMobilitySlice)AgentMobilityService.this.getFreshSlice(where.getName());
                                    dest.createAgent(newID, bytes, classSiteName, true, true);
                                }
                                if (AgentMobilityService.this.myLogger.isLoggable(Logger.FINE)) {
                                    AgentMobilityService.this.myLogger.log(Logger.FINE, "Cloned Agent " + newID + " correctly created on destination container");
                                }
                                break block23;
                            }
                            catch (IOException ioe) {
                                throw new IMTPException("I/O serialization error in handleInformCloned()", ioe);
                            }
                            catch (ServiceException se) {
                                throw new IMTPException("Destination container not found in handleInformCloned()", se);
                            }
                            catch (Exception e) {
                                throw new IMTPException("Error accessing to agent's code in handleInformCloned()", e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var19_17 = null;
                            AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
                            throw throwable;
                        }
                    }
                    Object var19_14 = null;
                    AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
                    return;
                }
                Object var19_15 = null;
                AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
                return;
            }
            Object var19_16 = null;
            AgentMobilityService.this.myContainer.releaseLocalAgent(agentID);
        }
    }
}

